/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitCommit;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import com.aptana.git.ui.internal.actions.GitRevision;
import com.aptana.git.ui.internal.history.GitHistoryPage;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.internal.text.revisions.Colors;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.team.ui.history.RevisionAnnotationController;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class BlameHandler
extends AbstractGitHandler {
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        Collection<IResource> resources = this.getSelectedResources();
        for (IResource resource : resources) {
            IWorkbenchPage page;
            if (resource.getType() != 1) continue;
            IFile file = (IFile)resource;
            GitRepository repo = GitPlugin.getDefault().getGitRepositoryManager().getAttached(file.getProject());
            RevisionInformation info = this.createRevisionInformation(repo, repo.relativePath((IResource)file));
            IEditorPart editorPart = this.getEditor();
            AbstractDecoratedTextEditor fEditor = null;
            if (editorPart instanceof AbstractDecoratedTextEditor) {
                fEditor = (AbstractDecoratedTextEditor)editorPart;
            }
            if (fEditor == null && (page = this.getActivePage()) != null) {
                try {
                    fEditor = (AbstractDecoratedTextEditor)IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                }
                catch (PartInitException e) {
                    IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
                }
            }
            if (fEditor == null) continue;
            fEditor.showRevisionInformation(info, "com.aptana.git.ui.quickdiff");
            page = this.getActivePage();
            if (page == null) continue;
            this.attachHistorySyncher(file, repo, page);
        }
        return null;
    }

    protected IHistoryView attachHistorySyncher(IFile file, final GitRepository repo, IWorkbenchPage page) {
        IHistoryPage historyPage;
        IHistoryView historyView = TeamUI.getHistoryView();
        if (historyView != null && (historyPage = historyView.showHistoryFor((Object)file)) instanceof GitHistoryPage) {
            new RevisionAnnotationController(page, file, ((GitHistoryPage)historyPage).getSelectionProvider()){

                protected Object getHistoryEntry(Revision selected) {
                    String sha = selected.getId();
                    return new GitCommit(repo, sha);
                }
            };
        }
        return historyView;
    }

    private RevisionInformation createRevisionInformation(GitRepository repo, IPath relativePath) {
        IStatus result = repo.execute(GitRepository.ReadWrite.READ, new String[]{"blame", "-p", relativePath.toOSString()});
        if (result == null || !result.isOK()) {
            return new RevisionInformation();
        }
        String output = result.getMessage();
        HashMap<String, GitRevision> revisions = new HashMap<String, GitRevision>();
        String[] lines = output.split("\r?\n|\r");
        GitRevision revision = null;
        String sha = null;
        String author = null;
        String committer = null;
        int finalLine = 1;
        int numberOfLines = 1;
        Calendar timestamp = null;
        String summary = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (sha == null) {
                String[] parts = line.split("\\s");
                sha = new String(parts[0]);
                finalLine = Integer.parseInt(parts[2]);
                if (parts.length > 3) {
                    numberOfLines = Integer.parseInt(parts[3]);
                }
            } else if (line.startsWith("author ")) {
                author = new String(line.substring(7));
            } else if (line.startsWith("summary ")) {
                summary = new String(line.substring(8));
            } else if (line.startsWith("committer-time ")) {
                String time = line.substring(15);
                long timeValue = Long.parseLong(time) * 1000L;
                timestamp = Calendar.getInstance();
                timestamp.setTimeInMillis(timeValue);
            } else if (line.startsWith("committer ")) {
                committer = new String(line.substring(10));
            } else if (line.charAt(0) == '\t') {
                revision = (GitRevision)((Object)revisions.get(sha));
                if (revision == null) {
                    revision = new GitRevision(sha, author, committer, summary, timestamp.getTime());
                }
                revision.addRange((ILineRange)new LineRange(finalLine - 1, numberOfLines));
                revisions.put(sha, revision);
                sha = null;
                revision = null;
                author = null;
                committer = null;
                timestamp = null;
                summary = null;
                numberOfLines = 1;
                finalLine = 1;
            }
            ++n2;
        }
        RevisionInformation info = new RevisionInformation();
        if (!revisions.isEmpty()) {
            ArrayList<String> uniqueAuthors = new ArrayList<String>();
            for (GitRevision rev : revisions.values()) {
                if (uniqueAuthors.contains(rev.getAuthor())) continue;
                uniqueAuthors.add(rev.getAuthor());
            }
            RGB[] colors = uniqueAuthors.size() < 2 ? new RGB[]{new RGB(255, 0, 0)} : Colors.rainbow((int)uniqueAuthors.size());
            for (GitRevision rev : revisions.values()) {
                rev.setColor(colors[uniqueAuthors.indexOf(rev.getAuthor())]);
                info.addRevision((Revision)rev);
            }
        }
        return info;
    }
}

